#!/usr/bin/env python
from flask import Flask, render_template, request, redirect, url_for, abort, session
from subprocess import call

##picup party pi web server.  Port 3131 (change below)
#Location for the images to display on the local web page
app = Flask(__name__,static_url_path='/static')


@app.route('/')
@app.route('/index')
def home():
    return render_template('index.html')

@app.route('/cmd/')
def cmd():
    return render_template('cmd.html')

@app.route("/cmd/change", methods=['POST'])
def change():
    returnText = "none"
    #print url_for('change')

    if request.method == 'POST':
        # Get the value from the submitted form
        responseText = request.form['button1']
        if responseText == "boot":
            returnText = "Rebooting"
            try:
		call(["sudo reboot now"],shell=True)
            except:
                print returnText

        if responseText == "down":
            returnText = "Shutting Down"
            try:
                call(["sudo shutdown now"],shell=True)
            except:
                print returnText

        if responseText == "raspicfg":
            returnText = "raspi-config"
            try:
                call(["sudo raspi-config"],shell=True)
            except:
                print returnText

        if responseText == "ifconfig":
            returnText = "On 4"
            try:
                call(["ifconfig"],shell-True)
            except:
                print returnText

        if responseText == "snapshot":
            returnText = "snapshot"
            try:
                call(["/home/pi/bin/local/picup.sh"],shell=True)
            except:
                print returnText

        if responseText == "localpic":
            returnText = "localpic"
            try:
                call(["/home/pi/bin/picupweb/local/piclocal.sh"],shell=True)
            except:
                print returnText

        if responseText == "wifihome":
            returnText = "wifihome"
            try:
                call(["sudo ~/bin/wifih.sh"],shell=True)
            except:
                print returnText

        if responseText == "wifimobile":
            returnText = "wifimobile"
            try:
		call(["sudo ~/bin/wifim.sh"],shell=True)
            except:
                print returnText


    return render_template('cmd.html', value=returnText)

if __name__ == "__main__":
    #those are for development
    #app.debug = True
    #app.run()

    #this will allow the server to be seen by outside world  
    app.run(host='0.0.0.0',port=3131)
